/**
 * 
 */
package gov.va.genisis2.ms.data.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 
 * @author PII
 *
 */
@Entity
@Table(name = "data_element_source")
public class DataElement implements Serializable {

	private static final long serialVersionUID = 6928520701957905981L;

	@Id
	@Column(name = "id")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private int id;

	@Column(name = "data_element_type_id", insertable = false, updatable = false)
	private int dateElementTypeId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "data_element_type_id")
	private DataElementType dataElementType;

	@Column(name = "data_type_id", insertable = false, updatable = false)
	private int dataTypeId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "data_type_id")
	private DataType dataType;

	@Column(name = "data_element_source_id", insertable = false, updatable = false)
	private int dataElementSourceId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "data_element_source_id")
	private DataElementSource dataElementSource;

	@Column(name = "path")
	private String path;

	@Column(name = "units")
	private String units;

	@Column(name = "algorithm")
	private String algorithm;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the dateElementTypeId
	 */
	public int getDateElementTypeId() {
		return dateElementTypeId;
	}

	/**
	 * @param dateElementTypeId
	 *            the dateElementTypeId to set
	 */
	public void setDateElementTypeId(int dateElementTypeId) {
		this.dateElementTypeId = dateElementTypeId;
	}

	/**
	 * @return the dataElementType
	 */
	public DataElementType getDataElementType() {
		return dataElementType;
	}

	/**
	 * @param dataElementType
	 *            the dataElementType to set
	 */
	public void setDataElementType(DataElementType dataElementType) {
		this.dataElementType = dataElementType;
	}

	/**
	 * @return the dataTypeId
	 */
	public int getDataTypeId() {
		return dataTypeId;
	}

	/**
	 * @param dataTypeId
	 *            the dataTypeId to set
	 */
	public void setDataTypeId(int dataTypeId) {
		this.dataTypeId = dataTypeId;
	}

	/**
	 * @return the dataType
	 */
	public DataType getDataType() {
		return dataType;
	}

	/**
	 * @param dataType
	 *            the dataType to set
	 */
	public void setDataType(DataType dataType) {
		this.dataType = dataType;
	}

	/**
	 * @return the dataElementSourceId
	 */
	public int getDataElementSourceId() {
		return dataElementSourceId;
	}

	/**
	 * @param dataElementSourceId
	 *            the dataElementSourceId to set
	 */
	public void setDataElementSourceId(int dataElementSourceId) {
		this.dataElementSourceId = dataElementSourceId;
	}

	/**
	 * @return the dataElementSource
	 */
	public DataElementSource getDataElementSource() {
		return dataElementSource;
	}

	/**
	 * @param dataElementSource
	 *            the dataElementSource to set
	 */
	public void setDataElementSource(DataElementSource dataElementSource) {
		this.dataElementSource = dataElementSource;
	}

	/**
	 * @return the path
	 */
	public String getPath() {
		return path;
	}

	/**
	 * @param path
	 *            the path to set
	 */
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * @return the units
	 */
	public String getUnits() {
		return units;
	}

	/**
	 * @param units
	 *            the units to set
	 */
	public void setUnits(String units) {
		this.units = units;
	}

	/**
	 * @return the algorithm
	 */
	public String getAlgorithm() {
		return algorithm;
	}

	/**
	 * @param algorithm
	 *            the algorithm to set
	 */
	public void setAlgorithm(String algorithm) {
		this.algorithm = algorithm;
	}
}
